# bark_beetle_random.R
# One-way ANOVA for bark beetle trapping experiment

# Load necessary libraries
library(ggplot2)
library(lme4)

# Read in data set
bbdata <- read.table(header=T,
colClasses=c("factor","numeric"),text="site count
1   137
1   101
1   113
1    48
1   155
2   156
2   165
2   652
2   179
2   757
3   278
3   197
3    95
3   395
3    83
4  2540
4   613
4   200
4   251
4   390
5    18
5    16
5    11
5    21
5    14
")

# Apply transformations here
bbdata <- transform(bbdata,y=log10(count))

# Print data
bbdata

# Graphics using ggplot2
ggplot(bbdata,aes(site,y))+
geom_jitter(size=2,position=position_jitter(width=0.1))+
stat_summary(fun="mean",geom="point",size=3)+
stat_summary(fun.data="mean_cl_normal",geom="errorbar",width=0.2,linewidth=1)

# One-way ANOVA with random effects - F test
aovout <- aov(y~site,data=bbdata)
anova(aovout)

# One-way ANOVA with random effects - variance components
lmerout <- lmer(y~(1|site),data=bbdata)
summary(lmerout)

# Diagnostic plots to check ANOVA assumptions
p <- fitted(lmerout)
r <- resid(lmerout)
plot(p,r)
qqnorm(r)
